@if ($comment->parent_id == 0)
    <div class="parent-comment-wrapper" id="parent-comment-{{ $comment->id }}">
@endif

<div class="comment-box-item comment-item @if ($comment->parent_id == 0) parentComment @else childComment @endif @if ($comment->is_hidden == 1) hideComment @endif"
     id="comment-{{ $comment->id }}" data-comment-id="{{ $comment->id }}">

    <div class="comment-box-item__thumb">
        <img src="{{ getImage(getFilePath('userProfile') . '/' . $comment->user->image, isAvatar: true) }}"
             alt="User Image">
    </div>

    <div class="comment-box-item__content">
        <div class="d-flex justify-content-between">
            <div class="w-100">
                <p class="comment-box-item__name">
                    {{ $comment->user->channel_name ?: $comment->user->fullname }}
                    <span class="time">{{ $comment->created_at->diffForHumans() }}</span>
                </p>
                <p class="comment-box-item__text">{{ $comment->comment }}</p>

                <div class="reaction-btn">
                    <div class="reaction-btn-inner">
                        @include('Template::partials.comment_reaction')
                    </div>
                    <div class="reaction-btn__reply">
                        <button class="reply">
                            <span class="icon"><i class="las la-reply"></i></span>
                            @lang('Reply')
                        </button>
                    </div>
                </div>
            </div>

            <div>
                <ul class="d-flex comment-manage-option">
                    @if (auth()->id() === $video->user_id && $comment->parent_id == 0 && !$comment->is_hidden)
                        <li class="pin-btn-wrapper">
                            <button class="pin-comment-btn comment-manage-btn" data-id="{{ $comment->id }}">
                                <i
                                   class="{{ $comment->pinned ? 'fa-solid fa-thumbtack unpin' : 'fa-solid fa-thumbtack' }}"></i>
                            </button>
                        </li>
                    @endif

                    @if (auth()->id() === $video->user_id)
                        <li class="hide-btn-wrapper">
                            <button class="hide-comment-btn comment-manage-btn" data-id="{{ $comment->id }}">
                                <i class="{{ $comment->is_hidden ? 'fa-solid fa-eye' : 'fa-solid fa-eye-slash' }}"></i>
                            </button>
                        </li>
                    @endif


                    @if (auth()->id() === $comment->user_id && !$comment->is_hidden)
                        <li class="edit-btn-wrapper">
                            <button class="edit-comment-btn comment-manage-btn" data-id="{{ $comment->id }}">
                                <i class="fa-solid fa-pen-to-square"></i>
                            </button>
                        </li>
                    @endif

                    @if (auth()->id() === $video->user_id || auth()->id() === $comment->user_id)
                        <li class="delete-btn-wrapper">
                            <button class="delete-comment-btn comment-manage-btn" data-id="{{ $comment->id }}"
                                    data-question="@lang('Are you sure you want to remove all history')?">
                                <i class="fa-solid fa-trash-can"></i>
                            </button>
                        </li>
                    @endif
                </ul>
            </div>
        </div>

        @php
            $replies = $comment
                ->replies()
                ->where(function ($query) {
                    $query->where('user_id', auth()->id())->orWhere('replier_user_id', auth()->id());
                })
                ->get();
        @endphp
        @if ($comment->parent_id == 0 && count($replies) > 0)
            <div class="reply-wrapper">
                <form class="reply-form d-none mb-3">
                    <input name="reply_to" type="hidden" value="{{ @$comment->id }}" />
                    <textarea class="form--control reply-form__textarea commentBox" name="comment" placeholder="Add a comment"></textarea>
                    <div class="reply-form__input-btn">
                        <button class="reply-form__btn submit-reply" type="submit">
                            <i class="las la-paper-plane"></i>
                        </button>
                    </div>
                </form>

                @if (!blank($comment->replies))
                    <span class="show-reply">
                        <span class="icon"><i class="fas fa-chevron-down"></i></span>
                        <span class="text">@lang('Show Reply')</span>
                    </span>
                @endif



                <div class="append-reply d-none">
                    @foreach ($replies ?? [] as $reply)
                        @include($activeTemplate . 'partials.video.comment', ['comment' => $reply])
                    @endforeach
                </div>

            </div>
        @endif

    </div>
</div>

@if ($comment->parent_id == 0)
    </div>
@endif
